/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.logger.impl;

import io.gitlab.jfronny.commons.StringFormatter;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;

public class Formatter {
    public static String format(ResourceBundle bundle, String format, Object ... args) {
        format = Formatter.getResourceStringOrMessage(bundle, format);
        if (args != null && args.length > 0) {
            MessageFormat mf = new MessageFormat(format);
            Format[] formats = mf.getFormats();
            for (int i = 0; i < formats.length; ++i) {
                if (formats[i] != null) continue;
                formats[i] = StringFormatterFormat.INSTANCE;
            }
            mf.setFormats(formats);
            return mf.format(args);
        }
        return format;
    }

    public static String getResourceStringOrMessage(ResourceBundle bundle, String msg) {
        if (bundle == null || msg == null) {
            return msg;
        }
        try {
            return bundle.getString(msg);
        }
        catch (MissingResourceException ex) {
            return msg;
        }
        catch (ClassCastException ex) {
            return bundle.getObject(msg).toString();
        }
    }

    private static class StringFormatterFormat
    extends Format {
        private static final StringFormatterFormat INSTANCE = new StringFormatterFormat();

        private StringFormatterFormat() {
        }

        @Override
        public StringBuffer format(Object obj, @NotNull StringBuffer toAppendTo, @NotNull FieldPosition pos) {
            if (pos.getField() != 0 || pos.getBeginIndex() != 0 || pos.getEndIndex() != 0) {
                throw new IllegalArgumentException("FieldPosition must be zero");
            }
            toAppendTo.append(StringFormatter.toString(obj));
            return toAppendTo;
        }

        @Override
        public Object parseObject(String source, @NotNull ParsePosition pos) {
            throw new UnsupportedOperationException();
        }
    }
}

